{include file="$template/includes/pageheader.tpl" title=$LANG.register.title}

<div class="register-page">
    <div class="container">
        <div class="register-box">
            <h2><i class="fa fa-user-plus"></i> {$_ADMINLANG.global.register}</h2>
            
            {if $errormessage}
                <div class="alert alert-danger">
                    <i class="fa fa-exclamation-circle"></i> {$errormessage}
                </div>
            {/if}
            
            <form method="post" action="{$systemurl}register.php" role="form">
                <input type="hidden" name="register" value="true">
                
                <div class="form-group">
                    <label for="firstname">{$_ADMINLANG.clientarea.firstname} <span class="text-danger">*</span></label>
                    <input type="text" name="firstname" id="firstname" class="form-control" value="{$clientfirstname}" required>
                </div>
                
                <div class="form-group">
                    <label for="lastname">{$_ADMINLANG.clientarea.lastname} <span class="text-danger">*</span></label>
                    <input type="text" name="lastname" id="lastname" class="form-control" value="{$clientlastname}" required>
                </div>
                
                <div class="form-group">
                    <label for="email">{$_ADMINLANG.clientarea.emailaddress} <span class="text-danger">*</span></label>
                    <input type="email" name="email" id="email" class="form-control" value="{$clientemail}" required>
                </div>
                
                <div class="form-group">
                    <label for="phonenumber">{$_ADMINLANG.clientarea.phonenumber}</label>
                    <input type="tel" name="phonenumber" id="phonenumber" class="form-control" value="{$clientphonenumber}">
                </div>
                
                <div class="form-group">
                    <label for="password">{$_ADMINLANG.clientarea.password} <span class="text-danger">*</span></label>
                    <input type="password" name="password" id="password" class="form-control" required>
                    <small class="form-text text-muted">En az 8 karakter olmalıdır</small>
                </div>
                
                <div class="form-group">
                    <label for="password2">{$_ADMINLANG.clientarea.confirmpassword} <span class="text-danger">*</span></label>
                    <input type="password" name="password2" id="password2" class="form-control" required>
                </div>
                
                {if $captcha}
                <div class="form-group">
                    <label>{$_ADMINLANG.global.captchaverify}</label>
                    <div class="captcha-container">
                        {$captcha}
                    </div>
                </div>
                {/if}
                
                <div class="form-group form-check">
                    <input type="checkbox" class="form-check-input" id="accepttos" name="accepttos" required>
                    <label class="form-check-label" for="accepttos">
                        <a href="{$WEB_ROOT}/terms.php" target="_blank">{$_ADMINLANG.order.termsofservice}</a> ve 
                        <a href="{$WEB_ROOT}/privacy.php" target="_blank">{$_ADMINLANG.order.privacy}</a> şartlarını kabul ediyorum <span class="text-danger">*</span>
                    </label>
                </div>
                
                <button type="submit" class="btn btn-primary btn-block btn-lg">
                    <i class="fa fa-user-plus"></i> {$_ADMINLANG.global.register}
                </button>
            </form>
            
            <hr class="my-4">
            
            <div class="text-center">
                <p class="text-muted">Zaten hesabınız var mı? <a href="{$WEB_ROOT}/clientarea.php" class="text-primary">{$_ADMINLANG.global.login}</a></p>
            </div>
        </div>
    </div>
</div>

{include file="$template/includes/pagefooter.tpl"}

