{include file="$template/includes/pageheader.tpl" title=$LANG.login.title}

<div class="login-page">
    <div class="container">
        <div class="login-box">
            <h2><i class="fa fa-sign-in"></i> {$_ADMINLANG.global.login}</h2>
            
            {if $incorrect}
                <div class="alert alert-danger">
                    <i class="fa fa-exclamation-circle"></i> {$_ADMINLANG.login.incorrect}
                </div>
            {/if}
            
            {if $verificationId && !$loggedin}
                <div class="alert alert-info">
                    <i class="fa fa-info-circle"></i> {$_ADMINLANG.login.verificationRequired}
                </div>
            {/if}
            
            <form method="post" action="{$systemurl}dologin.php" role="form">
                <div class="form-group">
                    <label for="inputEmail">{$_ADMINLANG.clientarea.emailaddress}</label>
                    <input type="email" name="username" class="form-control" id="inputEmail" placeholder="{$_ADMINLANG.clientarea.emailaddress}" required autofocus>
                </div>
                
                <div class="form-group">
                    <label for="inputPassword">{$_ADMINLANG.clientarea.password}</label>
                    <input type="password" name="password" class="form-control" id="inputPassword" placeholder="{$_ADMINLANG.clientarea.password}" required>
                </div>
                
                <div class="form-group form-check">
                    <input type="checkbox" class="form-check-input" id="rememberme" name="rememberme">
                    <label class="form-check-label" for="rememberme">
                        {$_ADMINLANG.login.rememberme}
                    </label>
                </div>
                
                <button type="submit" class="btn btn-primary btn-block btn-lg">
                    <i class="fa fa-sign-in"></i> {$_ADMINLANG.global.login}
                </button>
            </form>
            
            <hr class="my-4">
            
            <div class="text-center">
                <a href="{$WEB_ROOT}/pwreset.php" class="text-muted">
                    <i class="fa fa-key"></i> {$_ADMINLANG.login.forgotpassword}
                </a>
            </div>
            
            <div class="text-center mt-3">
                <p class="text-muted">Hesabınız yok mu? <a href="{$WEB_ROOT}/register.php" class="text-primary">{$_ADMINLANG.global.register}</a></p>
            </div>
        </div>
    </div>
</div>

{include file="$template/includes/pagefooter.tpl"}

