/**
 * Sunucuservisi.com WHMCS Theme
 * Main JavaScript File
 */

(function($) {
    'use strict';
    
    // Document Ready
    $(document).ready(function() {
        
        // Smooth scrolling for anchor links
        $('a[href^="#"]').on('click', function(event) {
            var target = $(this.getAttribute('href'));
            if( target.length ) {
                event.preventDefault();
                $('html, body').stop().animate({
                    scrollTop: target.offset().top - 76
                }, 1000);
            }
        });
        
        // Form validation enhancement
        $('form').on('submit', function() {
            var form = $(this);
            var isValid = true;
            
            form.find('input[required], select[required], textarea[required]').each(function() {
                if (!$(this).val()) {
                    isValid = false;
                    $(this).addClass('is-invalid');
                } else {
                    $(this).removeClass('is-invalid');
                }
            });
            
            return isValid;
        });
        
        // Remove invalid class on input
        $('input, select, textarea').on('input change', function() {
            $(this).removeClass('is-invalid');
        });
        
        // Password confirmation match
        $('#password2').on('keyup', function() {
            var password = $('#password').val();
            var password2 = $(this).val();
            
            if (password !== password2 && password2.length > 0) {
                $(this).addClass('is-invalid');
            } else {
                $(this).removeClass('is-invalid');
            }
        });
        
        // Auto-hide alerts after 5 seconds
        setTimeout(function() {
            $('.alert').fadeOut('slow');
        }, 5000);
        
        // Tooltip initialization
        $('[data-toggle="tooltip"]').tooltip();
        
        // Popover initialization
        $('[data-toggle="popover"]').popover();
        
        // Mobile menu close on click
        $('.navbar-nav .nav-link').on('click', function() {
            if ($(window).width() < 992) {
                $('.navbar-collapse').collapse('hide');
            }
        });
        
    });
    
    // Window Load
    $(window).on('load', function() {
        // Remove loading spinner if exists
        $('.loading-spinner').fadeOut();
    });
    
    // Window Scroll
    $(window).on('scroll', function() {
        var scrollTop = $(window).scrollTop();
        
        // Navbar shadow on scroll
        if (scrollTop > 50) {
            $('.navbar').addClass('navbar-scrolled');
        } else {
            $('.navbar').removeClass('navbar-scrolled');
        }
    });
    
})(jQuery);

