{include file="$template/includes/pageheader.tpl" title=$LANG.homepage.title}

<div class="hero-section">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <h1 class="hero-title">Güvenilir Hosting Çözümleri</h1>
                <p class="hero-subtitle">Web siteniz için en iyi performans ve güvenlik. 7/24 teknik destek ve %99.9 uptime garantisi ile hizmetinizdeyiz.</p>
                <div class="hero-buttons mt-4">
                    <a href="{$WEB_ROOT}/cart.php" class="btn btn-primary btn-lg mr-3">
                        <i class="fa fa-rocket"></i> Hizmetleri İncele
                    </a>
                    <a href="{$WEB_ROOT}/contact.php" class="btn btn-outline-light btn-lg">
                        <i class="fa fa-phone"></i> Bize Ulaşın
                    </a>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="hero-image">
                    <img src="{$WEB_ROOT}/templates/{$template}/img/hero-server.png" alt="Hosting" class="img-fluid">
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Features Section -->
<section class="features-section py-5">
    <div class="container">
        <div class="row text-center mb-5">
            <div class="col-12">
                <h2 class="section-title">Neden Bizi Seçmelisiniz?</h2>
                <p class="section-subtitle text-muted">Profesyonel hosting hizmetlerimiz ile işinizi büyütün</p>
            </div>
        </div>
        <div class="row">
            <div class="col-md-4 mb-4">
                <div class="feature-card text-center p-4">
                    <div class="feature-icon mb-3">
                        <i class="fa fa-server fa-3x text-primary"></i>
                    </div>
                    <h4>Yüksek Performans</h4>
                    <p class="text-muted">SSD diskler ve güçlü sunucular ile maksimum performans garantisi</p>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="feature-card text-center p-4">
                    <div class="feature-icon mb-3">
                        <i class="fa fa-shield fa-3x text-primary"></i>
                    </div>
                    <h4>Güvenlik</h4>
                    <p class="text-muted">SSL sertifikaları ve güncel güvenlik önlemleri ile verileriniz güvende</p>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="feature-card text-center p-4">
                    <div class="feature-icon mb-3">
                        <i class="fa fa-headphones fa-3x text-primary"></i>
                    </div>
                    <h4>7/24 Destek</h4>
                    <p class="text-muted">Uzman ekibimiz her zaman yanınızda, anında çözüm garantisi</p>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="feature-card text-center p-4">
                    <div class="feature-icon mb-3">
                        <i class="fa fa-clock-o fa-3x text-primary"></i>
                    </div>
                    <h4>%99.9 Uptime</h4>
                    <p class="text-muted">Kesintisiz hizmet garantisi ile web siteniz her zaman erişilebilir</p>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="feature-card text-center p-4">
                    <div class="feature-icon mb-3">
                        <i class="fa fa-cloud-upload fa-3x text-primary"></i>
                    </div>
                    <h4>Otomatik Yedekleme</h4>
                    <p class="text-muted">Günlük otomatik yedeklemeler ile verileriniz korunur</p>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="feature-card text-center p-4">
                    <div class="feature-icon mb-3">
                        <i class="fa fa-money fa-3x text-primary"></i>
                    </div>
                    <h4>Uygun Fiyatlar</h4>
                    <p class="text-muted">Kaliteli hizmet, uygun fiyat garantisi ile bütçenize uygun çözümler</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Pricing Section -->
{if $products}
<section class="pricing-section py-5 bg-light">
    <div class="container">
        <div class="row text-center mb-5">
            <div class="col-12">
                <h2 class="section-title">Hosting Paketlerimiz</h2>
                <p class="section-subtitle text-muted">İhtiyacınıza uygun paketi seçin</p>
            </div>
        </div>
        <div class="row">
            {foreach $products as $product}
            <div class="col-md-4 mb-4">
                <div class="pricing-card">
                    <div class="pricing-header">
                        <h3>{$product.name}</h3>
                        <div class="pricing-price">
                            <span class="currency">{$product.pricing.minprice.currency.prefix}</span>
                            <span class="amount">{$product.pricing.minprice.monthly}</span>
                            <span class="period">/ay</span>
                        </div>
                    </div>
                    <div class="pricing-body">
                        {if $product.description}
                            <p class="text-muted">{$product.description}</p>
                        {/if}
                        <a href="{$WEB_ROOT}/cart.php?a=add&pid={$product.pid}" class="btn btn-primary btn-block">
                            <i class="fa fa-shopping-cart"></i> Sipariş Ver
                        </a>
                    </div>
                </div>
            </div>
            {/foreach}
        </div>
    </div>
</section>
{/if}

<!-- Announcements Section -->
{if $announcements}
<section class="announcements-section py-5">
    <div class="container">
        <div class="row text-center mb-5">
            <div class="col-12">
                <h2 class="section-title">Duyurular</h2>
            </div>
        </div>
        <div class="row">
            {foreach $announcements as $announcement}
            <div class="col-md-6 mb-4">
                <div class="announcement-card">
                    <div class="announcement-date">
                        <i class="fa fa-calendar"></i> {$announcement.date}
                    </div>
                    <h4><a href="{$WEB_ROOT}/announcements.php?id={$announcement.id}">{$announcement.title}</a></h4>
                    <p class="text-muted">{$announcement.text|truncate:150}</p>
                    <a href="{$WEB_ROOT}/announcements.php?id={$announcement.id}" class="read-more">Devamını Oku <i class="fa fa-arrow-right"></i></a>
                </div>
            </div>
            {/foreach}
        </div>
    </div>
</section>
{/if}

{include file="$template/includes/pagefooter.tpl"}

