<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{if $kbarticle.title}{$kbarticle.title} - {/if}{if $pagetitle}{$pagetitle} - {/if}{$companyname}</title>
    
    
    <!-- Bootstrap CSS (CDN) -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-xOolHFLEh07PJGoPkLv1IbcEPTNtaed2xpHsD9ESMhqIYd0nLMwNLD69Npy4HI+N" crossorigin="anonymous">
    <!-- Font Awesome (CDN) -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet" integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <!-- Custom Theme CSS -->
    <link href="{$WEB_ROOT}/templates/{$template}/css/style.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    {if $templatefile eq "viewinvoice" || $templatefile eq "viewquote"}
        <link href="{$WEB_ROOT}/templates/{$template}/css/invoice.css" rel="stylesheet">
    {/if}
    
    {foreach $headoutput as $output}
        {$output}
    {/foreach}
</head>
<body class="page-{$templatefile}">

    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary fixed-top">
        <div class="container">
            <a class="navbar-brand" href="{$WEB_ROOT}/">
                <img src="{$WEB_ROOT}/templates/{$template}/img/logo.png" alt="{$companyname}" height="40" class="logo-img">
                <span class="logo-text">{$companyname}</span>
            </a>
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ml-auto">
                    {if $loggedin}
                        <li class="nav-item">
                            <a class="nav-link" href="{$WEB_ROOT}/clientarea.php">
                                <i class="fa fa-home"></i> {$_ADMINLANG.clientarea.title}
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="{$WEB_ROOT}/clientarea.php?action=services">
                                <i class="fa fa-server"></i> {$_ADMINLANG.clientarea.services}
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="{$WEB_ROOT}/clientarea.php?action=invoices">
                                <i class="fa fa-file-text"></i> {$_ADMINLANG.clientarea.invoices}
                            </a>
                        </li>
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fa fa-user"></i> {$clientsdetails.firstname} {$clientsdetails.lastname}
                            </a>
                            <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown">
                                <a class="dropdown-item" href="{$WEB_ROOT}/clientarea.php?action=details">
                                    <i class="fa fa-user"></i> {$_ADMINLANG.clientarea.accountdetails}
                                </a>
                                <a class="dropdown-item" href="{$WEB_ROOT}/clientarea.php?action=changepw">
                                    <i class="fa fa-lock"></i> {$_ADMINLANG.clientarea.changepassword}
                                </a>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item" href="{$WEB_ROOT}/logout.php">
                                    <i class="fa fa-sign-out"></i> {$_ADMINLANG.clientarea.logout}
                                </a>
                            </div>
                        </li>
                    {else}
                        <li class="nav-item">
                            <a class="nav-link" href="{$WEB_ROOT}/index.php">
                                <i class="fa fa-home"></i> {$_ADMINLANG.global.home}
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="{$WEB_ROOT}/cart.php">
                                <i class="fa fa-shopping-cart"></i> {$_ADMINLANG.global.order}
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="{$WEB_ROOT}/clientarea.php">
                                <i class="fa fa-sign-in"></i> {$_ADMINLANG.global.login}
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link btn btn-outline-light btn-sm ml-2" href="{$WEB_ROOT}/register.php">
                                {$_ADMINLANG.global.register}
                            </a>
                        </li>
                    {/if}
                </ul>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main class="main-content">
        {if $templatefile neq "homepage" && $templatefile neq "login" && $templatefile neq "register"}
            <div class="page-header">
                <div class="container">
                    <h1 class="page-title">{$pagetitle}</h1>
                    {if $breadcrumbnav}
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                {foreach $breadcrumbnav as $breadcrumb}
                                    <li class="breadcrumb-item {if $breadcrumb@last}active{/if}">
                                        {if $breadcrumb@last}
                                            {$breadcrumb.label}
                                        {else}
                                            <a href="{$breadcrumb.link}">{$breadcrumb.label}</a>
                                        {/if}
                                    </li>
                                {/foreach}
                            </ol>
                        </nav>
                    {/if}
                </div>
            </div>
        {/if}

